/**
* Script: screen.js
* Written by: Radnen
* Updated: 10/26/2010
**/

// I offer a night/morning time values to use in the engine //
const NIGHT = CreateColor(10, 10, 40, 125);
const MORNING = CreateColor(255, 230, 180, 32);

// This is the engine, a game will typically consist of 1 engine //
// A second engine may be used separately for day/night however //
var Screen = ({
	color: CreateColor(0, 0, 0, 0),
	ticks: 0,
	msecs: 0,
	time: 0,
	max: 255,
	fade: 0,
	done: true,

	// Call this whenever you want to fade the screen in //
	fadeIn: function(msecs) {
		this.msecs = msecs;
		this.time = GetTime();
		this.fade = FADE_IN;
		this.color.alpha = 255;
		this.done = false;
	},

	// Call this whenever you want to fade the screen out //
	fadeOut: function(msecs) {
		this.msecs = msecs;
		this.time = GetTime();
		this.fade = FADE_OUT;
		this.color.alpha = 0;
		this.done = false;
	},

	// Call this whenever you want to immediately stop a fade or clear the screen from a fade out //
	clear: function() {
		this.fade = FADE_STOP;
		this.msecs = 0;
		this.time = 0;
		this.color.alpha = 0;
		this.done = true;
	},

	// Used to finish a fade immediately. Useful for long fades that can be player skipped(?).
	forceFinish: function() {
		this.fade = 0;
		this.msecs = 0;
		this.time = 0;
		(this.fade == 1) ? this.color.alpha = 0 : this.color.alpha = this.max;
		this.done = true;
	},

	// Use this to set the fade color.
	setColor: function(color) {
		var Alpha = this.color.alpha;
		this.color = CloneColor(color);
		this.color.alpha = Alpha;
	},

	waitForMe: function() {
		var lastFR = GetFrameRate();
		SetFrameRate(GetMapEngineFrameRate());
		while(!this.done) {
			RenderMap();
			UpdateMapEngine();
			FlipScreen();
		}
		SetFrameRate(lastFR);
	},
	
	// This is put inside a RenderScript();
	render: function() {
		if (!this.fade && !this.done) this.done = true;
		
		// Less control with SetLayerMask() or SetColorMask()
		Rectangle(0, 0, SW, SH, this.color);
	
		// Fade In:
		if (this.fade == FADE_OUT) {
			if (this.time + this.msecs > GetTime()) {
				this.color.alpha = (GetTime() - this.time) * this.max / this.msecs;
				if (this.color.alpha > 255) this.color.alpha = 255;
			}
			else this.fade = FADE_STOP;
		}
		
		// Fade Out:
		else if (this.fade == FADE_IN)	{
			if (this.time + this.msecs > GetTime())	{
				this.color.alpha = this.max - (GetTime() - this.time) * this.max / this.msecs;
			}
			else this.fade = FADE_STOP;
		}
	}
});